***********************************************************************
*
* darts umenu.asm -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements 
* menus in the program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.types
               copy 2/ainclude/e16.event
               copy darts.equ

               mcopy macros/umenu.macros

               longi on
               longa on

***********************************************************************
*
* doAboutItem
*
* Calls AlertWindow to display the about box.  The result is ignored.
*
doAboutItem    start

               pha
               pea refIsResource*2
               PushLong #0
               PushLong #1
               _AlertWindow
               pla
               rts

               end

***********************************************************************
*
* doNewItem
*
* Inits the current window for a new game.  Can be called in response
* to a menu selection or button press.
*
doNewItem      start

               stz score                ;Zap the old scores.
               stz score+2
               pea Player1
               jsr invalScore
               pea Player2
               jsr invalScore

               pea Player1              ;Clear the lists.
               jsr clearList
               pea Player2
               jsr clearList

               ldy #26*2*2-2            ;Zap the crickett tables.
               lda #0
aa             sta crickettTables,y
               dey
               dey
               bpl aa

               lda gameType
               beq robinGame            ;That's all for Robin.

               ldy #25                  ;Zap the button titles.
ab             phy                      ;Push YREG.

               pea Player1
               phy                      ;Button to change.
               jsr fixButtonTitle

               ply
               phy                      ;Restore YREG.

               pea Player2
               phy                      ;Button to change.
               jsr fixButtonTitle

               ply                      ;Pull YREG.

               cpy #25
               bne ac
               ldy #21
ac             dey
               cpy #15
               bcs ab

               stz weHaveAWinner

robinGame      rts

               end

***********************************************************************
*
* doQuitItem
*
* Sets the global done flag to true in response to the quit menu time.
* Can also be called in reponse to the quit button.
*
doQuitItem     start

               inc quitFlag             ;That's all folks.
               rts

               end

***********************************************************************
*
* doSwitchGames
*
* Switches from Robin to Crickett and back again.  This is called in
* response to selections in the Game menu.  Note:  that if the selected
* item is the current game, then nothing happens.
*
doSwitchGames  start

               DefineStack

saveDPage      word
returnAddr     word

itemNum        word

******************

               phd                      ;Save directPage register.
               tsc                      ;Set directPage register.
               tcd

               ldx #0                   ;Which game are we switching to?
               lda itemNum
               cmp #RobinGameItem
               beq aa
               inx
aa             stx itemNum

               cpx gameType
               beq isCurrentGame        ;Already playing that game.

               lda theWindow+2          ;Close the old window.
               pha
               lda theWindow
               pha
               _CloseWindow

               lda itemNum              ;Start up one or the other.
               bne crickett
               jsr startupRobinGame
               bra newGame

crickett       jsr startupCrickettGame

newGame        lda itemNum
               sta gameType
               jsr doNewItem            ;Inits current window for new game.

isCurrentGame  anop
exit           anop
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               phx                      ;Restore return address and return.
               rts

               end

***********************************************************************
*
* doMenu
*
* This resonds to menu selections.  It is called by main event loop in 
* response to all menu selctions (mouse and keyboard).
*
doMenu         start

               DefineStack

menuNum        word
itemNum        word

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               tsc                      ;Set directPage register.
               tcd

               lda event+owmTaskData+2
               sta menuNum
               lda event+owmTaskData
               sta itemNum

               cmp #AboutItem           ;Branch to correct thing
               bne aa                   ;to do, and do it.
               jsr doAboutItem
               bra hilite

aa             cmp #NewItem
               bne ab
               jsr doNewItem
               bra hilite

ab             cmp #QuitItem
               bne ac
               jsr doQuitItem
               bra hilite

ac             cmp #RobinGameItem
               beq ad
               cmp #CrickettGameItem
               bne hilite

ad             pei itemNum
               jsr doSwitchGames

hilite         pea 0
               pei menuNum
               _HiliteMenu

               pla                      ;Remove local variable space.
               pla
               pld                      ;Restore directPage register.
               rts

               end

***********************************************************************
*
* setupMenus
*
* Creates the system menu bar with desk accessories.
*
setupMenus     start

               pha
               pha
               pea refIsResource
               PushLong #1
               PushLong #0
               _NewMenuBar2
               _SetSysBar

               PushLong #0
               _SetMenuBar

               pea AppleMenuID
               _FixAppleMenu

               pha
               _FixMenuBar
               pla

               _DrawMenuBar

               rts

               end

               END
